/*
 * Decompiled with CFR 0.152.
 */
package sleeper.main;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.World;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import sleeper.main.Commands;
import sleeper.main.EventHandlers;
import sleeper.main.Metrics;

public class Main
extends JavaPlugin {
    DecimalFormat dfrmt = new DecimalFormat();
    Commands commands;
    EventHandlers eventhandlers;
    boolean useAnimation = true;
    int skipPercentage = 25;
    int skipSpeed = 100;
    boolean broadcastSleepInfo = false;
    boolean useVote = false;
    int yesMultiplier = 1;
    int noMultiplier = 1;
    int skipVotePercent = 50;
    boolean blockBedsAfterVoting = false;
    boolean bossbarVoteCount = true;
    boolean sendVotesOnStart = true;
    boolean voteStarts = false;
    ArrayList<String> voting = new ArrayList();
    HashMap<String, String> yesVotes = new HashMap();
    HashMap<String, String> noVotes = new HashMap();
    ArrayList<String> skipping = new ArrayList();
    ArrayList<String> recentlySkipped = new ArrayList();
    HashMap<String, Integer> skipWorlds = new HashMap();
    ArrayList<UUID> ignorePlayers = new ArrayList();
    ArrayList<UUID> debugPlayers = new ArrayList();
    HashMap<String, Float> sleepingWorlds = new HashMap();
    HashMap<String, Float> playersOnline = new HashMap();
    BossBar bar = Bukkit.createBossBar((String)"", (BarColor)BarColor.GREEN, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
    String sleepInfo = "&aSleep > &7 %percent% (%count%) out of a minimum of 25% sleeping.";
    String nightSkip = "&aSleep > &7At least 25% of online users sleeping (%count%), skipping the night.";
    String ignored = "&cSleep > &7You are still being ignored for sleep calculations!";
    String voteTitle = "&aSleep > &7Vote below on skipping the night:";
    String voteYes = "&a&lYes";
    String voteNo = "&c&lNo";
    String votedYes = "&aYou voted to skip the night.";
    String votedNo = "&aYou voted not to skip the night.";
    String noVote = "&cYour world isn't voting on a night skip.";
    String alreadyYes = "&cYou have already voted yes.";
    String alreadyNo = "&cYou have already voted no.";
    String sleepHelpList = "&cInvalid command, valid subcommands are: ";
    String noPermission = "&cYou don't have permission for that.";
    String listVotes = "&aYes: &7%yes% &cNo: &7%no%";
    String skipByVote = "&aSleep > &7The vote has decided to skip the night!";
    String voteNotEnabled = "&cVoting is not enabled.";

    public void onDisable() {
        PluginDescriptionFile pdfFile = this.getDescription();
        this.getLogger().info(pdfFile.getName() + " Has Been Disabled!");
    }

    public void onEnable() {
        PluginDescriptionFile pdfFile = this.getDescription();
        this.getLogger().info(pdfFile.getName() + " Version " + pdfFile.getVersion() + " Has Been Enabled!");
        int pluginId = 15317;
        Metrics metrics = new Metrics(this, pluginId);
        PluginManager pm = this.getServer().getPluginManager();
        this.eventhandlers = new EventHandlers(this);
        this.commands = new Commands(this, this.eventhandlers);
        this.getCommand("sleep").setExecutor((CommandExecutor)this.commands);
        pm.registerEvents((Listener)this.eventhandlers, (Plugin)this);
        this.setConfig();
        this.loadConfig();
        this.dfrmt.setMaximumFractionDigits(2);
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> {
            long time;
            World world;
            ArrayList<String> remove = new ArrayList<String>();
            for (final String worldName : this.skipping) {
                if (!this.useAnimation) continue;
                world = Bukkit.getWorld((String)worldName);
                time = world.getTime();
                world.setTime(time + (long)this.skipSpeed);
                world.setStorm(false);
                if (time >= 24000L) {
                    world.setTime(0L);
                    time = 0L;
                }
                if (time >= 2000L) continue;
                remove.add(worldName);
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

                    @Override
                    public void run() {
                        Main.this.sleepingWorlds.put(worldName, Float.valueOf(0.0f));
                        Main.this.recentlySkipped.remove(worldName);
                    }
                }, 20L);
            }
            remove.forEach(name -> {
                boolean bl = this.skipping.remove(name);
            });
            remove.clear();
            for (final String worldName : this.voting) {
                float skipMargin;
                int nVotes;
                world = Bukkit.getWorld((String)worldName);
                time = world.getTime();
                if (this.skipping.contains(worldName)) continue;
                if (this.bossbarVoteCount) {
                    this.bar.setTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)this.listVotes.replace("%yes%", this.dfrmt.format(this.countYes(worldName))).replace("%no%", this.dfrmt.format(this.countNo(worldName)))));
                    for (Player player2 : world.getPlayers()) {
                        if (this.bar.getPlayers().contains(player2)) continue;
                        this.bar.addPlayer(player2);
                    }
                }
                if (time < 2000L) {
                    remove.add(worldName);
                    this.bar.removeAll();
                    ArrayList<String> removeVotes = new ArrayList<String>();
                    for (Map.Entry<String, String> vote : this.yesVotes.entrySet()) {
                        if (!vote.getValue().equals(worldName)) continue;
                        removeVotes.add(vote.getKey());
                    }
                    removeVotes.forEach(name -> {
                        String string = this.yesVotes.remove(name);
                    });
                    removeVotes.clear();
                    for (Map.Entry<String, String> vote : this.noVotes.entrySet()) {
                        if (!vote.getValue().equals(worldName)) continue;
                        removeVotes.add(vote.getKey());
                    }
                    removeVotes.forEach(name -> {
                        String string = this.noVotes.remove(name);
                    });
                    removeVotes.clear();
                    continue;
                }
                int yVotes = this.countYes(worldName);
                float skipFactor = (float)(yVotes * this.yesMultiplier - (nVotes = this.countNo(worldName)) * this.noMultiplier) / this.playersOnline.get(worldName).floatValue();
                if (!(skipFactor >= (skipMargin = (float)this.skipVotePercent * 0.01f))) continue;
                this.skipping.add(worldName);
                this.recentlySkipped.add(worldName);
                world.getPlayers().forEach(player -> this.sendMessage((Player)player, ChatColor.translateAlternateColorCodes((char)'&', (String)this.skipByVote)));
                this.getLogger().info("Skipping night by vote in " + worldName);
            }
            remove.forEach(name -> {
                boolean bl = this.voting.remove(name);
            });
        }, 1L, 1L);
    }

    public void loadConfig() {
        this.reloadConfig();
        FileConfiguration config = this.getConfig();
        this.useAnimation = config.getBoolean("UseAnimation");
        this.skipPercentage = config.getInt("SkipPercentage");
        this.skipSpeed = config.getInt("SkipSpeed");
        this.sleepInfo = config.getString("SleepInfo");
        this.nightSkip = config.getString("NightSkip");
        this.ignored = config.getString("Ignored");
        this.useVote = config.getBoolean("VoteSkip");
        this.yesMultiplier = config.getInt("YesMultiplier");
        this.noMultiplier = config.getInt("NoMultiplier");
        this.skipVotePercent = config.getInt("SkipVotePercent");
        this.voteTitle = config.getString("VoteTitle");
        this.voteYes = config.getString("VoteYes");
        this.voteNo = config.getString("VoteNo");
        this.votedYes = config.getString("VotedYes");
        this.votedNo = config.getString("VotedNo");
        this.noVote = config.getString("NoVote");
        this.alreadyYes = config.getString("AlreadyYes");
        this.alreadyNo = config.getString("AlreadyNo");
        this.sleepHelpList = config.getString("SleepHelpList");
        this.noPermission = config.getString("NoPermission");
        this.listVotes = config.getString("ListVotes");
        this.skipByVote = config.getString("SkipByVote");
        this.voteNotEnabled = config.getString("VoteNotEnabled");
        this.broadcastSleepInfo = config.getBoolean("BroadcastSleepInfo");
        this.blockBedsAfterVoting = config.getBoolean("BlockBedsAfterVoting");
        this.bossbarVoteCount = config.getBoolean("BossbarVoteCount");
        this.sendVotesOnStart = config.getBoolean("SendVotesOnStart");
        this.voteStarts = config.getBoolean("StartWithoutSleep");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setConfig() {
        File f = new File(String.valueOf(this.getDataFolder()) + File.separator + "config.yml");
        if (f.exists()) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)f);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                InputStream defConfigStream = this.getResource("config.yml");
                try {
                    try (InputStreamReader reader = new InputStreamReader(defConfigStream, StandardCharsets.UTF_8);){
                        YamlConfiguration defconf = YamlConfiguration.loadConfiguration((Reader)reader);
                        config.addDefaults((Configuration)defconf);
                        config.setDefaults((Configuration)defconf);
                        this.saveDefaultConfig();
                    }
                    if (defConfigStream == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (defConfigStream == null) throw throwable;
                    defConfigStream.close();
                    throw throwable;
                }
                defConfigStream.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendMessage(Player player, String message) {
        if (!message.equals("")) {
            player.sendMessage(message);
        }
    }

    public void sleep(final Player player) {
        final String pWorld = player.getWorld().getName();
        final World world = Bukkit.getWorld((String)pWorld);
        if (this.ignorePlayers.contains(player.getUniqueId())) {
            return;
        }
        final Main plugin = this;
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                if (player.isOnline() && player.isSleeping()) {
                    float wonline = Main.this.onlinePlayers(pWorld);
                    float wsleeping = Main.this.sleepingWorlds.getOrDefault(player.getWorld().getName(), Float.valueOf(0.0f)).floatValue();
                    Main.this.sleepingWorlds.put(pWorld, Float.valueOf(wsleeping += 1.0f));
                    float percentage = wsleeping / wonline * 100.0f;
                    if (percentage > 100.0f) {
                        percentage = 100.0f;
                    }
                    if (Main.this.debugPlayers.contains(player.getUniqueId())) {
                        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "DEBUG: " + String.valueOf(ChatColor.GRAY) + "eventhandlers.sleeping: ");
                        Main.this.sleepingWorlds.keySet().forEach(world -> player.sendMessage(String.valueOf(ChatColor.GRAY) + Main.this.sleepingWorlds.get(world).toString()));
                        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "DEBUG: " + String.valueOf(ChatColor.GRAY) + "eventhandlers.playersOnline: ");
                        Main.this.playersOnline.keySet().forEach(world -> player.sendMessage(String.valueOf(ChatColor.GRAY) + Main.this.playersOnline.get(world).toString()));
                        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "DEBUG: " + String.valueOf(ChatColor.GRAY) + "skipping: " + Main.this.skipping.toString());
                        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "DEBUG: " + String.valueOf(ChatColor.GRAY) + "voting: " + Main.this.voting.toString());
                    }
                    if (!Main.this.broadcastSleepInfo) {
                        Main.this.sendMessage(player, ChatColor.translateAlternateColorCodes((char)'&', (String)Main.this.sleepInfo.replace("%percent%", Main.this.dfrmt.format(percentage) + "%").replace("%count%", Main.this.dfrmt.format(wsleeping)).replace("%player%", player.getName())));
                    } else {
                        for (Player players : world.getPlayers()) {
                            Main.this.sendMessage(players, ChatColor.translateAlternateColorCodes((char)'&', (String)Main.this.sleepInfo.replace("%percent%", Main.this.dfrmt.format(percentage) + "%").replace("%count%", Main.this.dfrmt.format(wsleeping)).replace("%player%", player.getName())));
                        }
                    }
                    if (Main.this.debugPlayers.contains(player.getUniqueId())) {
                        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "DEBUG: " + String.valueOf(ChatColor.GRAY) + "Checking if should skip....");
                        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "DEBUG: sleeping/onlineplayers : " + String.valueOf(ChatColor.GRAY) + wsleeping / wonline);
                    }
                    if (Main.this.useVote) {
                        Main.this.startVote(player);
                        Main.this.voteYes(player);
                    }
                    if (percentage >= (float)Main.this.skipPercentage && !Main.this.skipping.contains(pWorld)) {
                        if (Main.this.debugPlayers.contains(player.getUniqueId())) {
                            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "DEBUG: " + String.valueOf(ChatColor.GRAY) + "Skipping...");
                        }
                        for (Player players : world.getPlayers()) {
                            Main.this.sendMessage(players, ChatColor.translateAlternateColorCodes((char)'&', (String)Main.this.nightSkip.replace("%percent%", Main.this.dfrmt.format(percentage) + "%").replace("%count%", Main.this.dfrmt.format(wsleeping)).replace("%player%", player.getName())));
                        }
                        Main.this.skipping.add(pWorld);
                        Main.this.recentlySkipped.add(pWorld);
                        if (!Main.this.useAnimation) {
                            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, new Runnable(){

                                @Override
                                public void run() {
                                    if (player.isOnline() && (this).Main.this.debugPlayers.contains(player.getUniqueId())) {
                                        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "DEBUG: " + String.valueOf(ChatColor.GRAY) + "Skipping after delay");
                                    }
                                    world.setTime(0L);
                                    world.setStorm(false);
                                    (this).Main.this.skipping.remove(pWorld);
                                    Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, new Runnable(){

                                        @Override
                                        public void run() {
                                            ((this).this).Main.this.sleepingWorlds.put(pWorld, Float.valueOf(0.0f));
                                            ((this).this).Main.this.recentlySkipped.remove(pWorld);
                                            if (player.isOnline() && ((this).this).Main.this.debugPlayers.contains(player.getUniqueId())) {
                                                player.sendMessage(String.valueOf(ChatColor.YELLOW) + "DEBUG: " + String.valueOf(ChatColor.GRAY) + "sleeping set to 0");
                                            }
                                        }
                                    }, 20L);
                                }
                            }, 120L);
                        } else if (Main.this.debugPlayers.contains(player.getUniqueId())) {
                            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "DEBUG: " + String.valueOf(ChatColor.GRAY) + "Skipping with animation");
                        }
                    }
                }
            }
        }, 1L);
    }

    public float onlinePlayers(String worldName) {
        float onlineIgnored = 0.0f;
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!this.ignorePlayers.contains(p.getUniqueId()) && p.getWorld().getName() == worldName && !p.getGameMode().equals((Object)GameMode.SPECTATOR) && !p.getGameMode().equals((Object)GameMode.CREATIVE)) continue;
            onlineIgnored += 1.0f;
        }
        float total = (float)Bukkit.getOnlinePlayers().size() - onlineIgnored;
        this.playersOnline.put(worldName, Float.valueOf(total));
        return total;
    }

    public ArrayList<Player> getOnlineIgnorers() {
        ArrayList<Player> players = new ArrayList<Player>();
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!this.ignorePlayers.contains(p.getUniqueId())) continue;
            players.add(p);
        }
        return players;
    }

    public void startVote(Player player) {
        World world = player.getWorld();
        String pWorld = world.getName();
        this.onlinePlayers(pWorld);
        if (!this.voting.contains(pWorld) && world.getTime() >= 12542L) {
            this.voting.add(pWorld);
            if (this.sendVotesOnStart) {
                world.getPlayers().forEach(wPlayer -> this.sendVoteMsg((Player)wPlayer));
            }
        } else if (world.getTime() >= 12542L) {
            this.sendVoteMsg(player);
        }
    }

    public void voteYes(Player player) {
        if (!player.hasPermission("sleeper.vote")) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.noPermission));
            return;
        }
        if (!this.useVote) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.voteNotEnabled));
            return;
        }
        if (this.voteStarts && !this.voting.contains(player.getWorld().getName())) {
            this.startVote(player);
        }
        if (!this.voting.contains(player.getWorld().getName())) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.noVote));
            return;
        }
        if (this.yesVotes.containsKey(player.getName())) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.alreadyYes));
            return;
        }
        if (this.noVotes.containsKey(player.getName())) {
            this.noVotes.remove(player.getName());
        }
        this.yesVotes.put(player.getName(), player.getWorld().getName());
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.votedYes));
        this.onlinePlayers(player.getWorld().getName());
        this.showVotes(player);
    }

    public void voteNo(Player player) {
        if (!player.hasPermission("sleeper.vote")) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.noPermission));
            return;
        }
        if (!this.useVote) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.voteNotEnabled));
            return;
        }
        if (this.voteStarts && !this.voting.contains(player.getWorld().getName())) {
            this.startVote(player);
        }
        if (!this.voting.contains(player.getWorld().getName())) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.noVote));
            return;
        }
        if (this.noVotes.containsKey(player.getName())) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.alreadyNo));
            return;
        }
        if (this.yesVotes.containsKey(player.getName())) {
            this.yesVotes.remove(player.getName());
        }
        this.noVotes.put(player.getName(), player.getWorld().getName());
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.votedNo));
        this.onlinePlayers(player.getWorld().getName());
        this.showVotes(player);
    }

    public int countYes(String worldName) {
        int yVotes = 0;
        for (Map.Entry<String, String> set : this.yesVotes.entrySet()) {
            if (!set.getValue().equals(worldName)) continue;
            ++yVotes;
        }
        return yVotes;
    }

    public int countNo(String worldName) {
        int nVotes = 0;
        for (Map.Entry<String, String> set : this.noVotes.entrySet()) {
            if (!set.getValue().equals(worldName)) continue;
            ++nVotes;
        }
        return nVotes;
    }

    public void sendVoteMsg(Player player) {
        if (!this.useVote) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.voteNotEnabled));
            return;
        }
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.voteTitle));
        TextComponent yesMessage = new TextComponent(TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)this.voteYes)));
        yesMessage.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/sleep yes"));
        player.spigot().sendMessage((BaseComponent)yesMessage);
        TextComponent noMessage = new TextComponent(TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)this.voteNo)));
        noMessage.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/sleep no"));
        player.spigot().sendMessage((BaseComponent)noMessage);
    }

    public void showVotes(Player player) {
        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)this.listVotes.replace("%yes%", this.dfrmt.format(this.countYes(player.getWorld().getName()))).replace("%no%", this.dfrmt.format(this.countNo(player.getWorld().getName())))));
    }

    public boolean hasVoted(Player player) {
        return this.yesVotes.containsKey(player.getName()) || this.noVotes.containsKey(player.getName());
    }
}

